import 'package:flutter/cupertino.dart';
import 'package:get/get.dart';
import 'package:nb_utils/nb_utils.dart';
import 'package:streamit_laravel/components/shimmer_widget.dart';
import 'package:streamit_laravel/utils/app_common.dart';


class ShimmerMovieList extends StatelessWidget {
  const ShimmerMovieList({super.key});

  @override
  Widget build(BuildContext context) {
    return SingleChildScrollView(
      padding: EdgeInsets.only(
        left: Get.width * 0.04,
        right: Get.width * 0.04,
        bottom: 24,
        top: 16,
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          /// Use fixed height instead of Get.height/2 to prevent overflow
          ShimmerWidget(
            height: Get.height / 2.2, // Or something like 220-250 based on your design
            width: Get.width,
            radius: 6,
          ).paddingOnly(bottom: 22),

          /// Wrap handles dynamic items nicely here
          AnimatedWrap(
            spacing: Get.width * 0.03,
            runSpacing: Get.height * 0.02,
            listAnimationType: commonListAnimationType,
            children: List.generate(
              5,
              (index) {
                return ShimmerWidget(
                  height: 150,
                  width: Get.width * 0.286,
                  radius: 6,
                );
              },
            ),
          ),
        ],
      ),
    );
  }
}